from bpy.types import PropertyGroup
# from ....libs.functions.get_common_vars import get_common_vars
from bpy.props import FloatProperty, BoolProperty, IntProperty, PointerProperty
from ..updaters.props_update_particles import particles_props_update
from .anim.props_springs_anim import ActiveEmitterSpringsAnimProps


class ActiveEmitterSpringsProps(PropertyGroup):

    """ Propiedades guardadas en el active_emitter_item.springs.x """

    # estas van a nivel grupo no de item:
    anim: PointerProperty(type=ActiveEmitterSpringsAnimProps)
    
    spring_force: FloatProperty(
        name="Force",
        default=0, 
        min=0, 
        soft_max=10,
        max=100.0,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "spring_force")
    )
    use_viscoelastic_springs: BoolProperty(
        name="Viscoelastic Springs",
        description="Use viscoelastic springs instead of Hooke's springs",
        default=False,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "use_viscoelastic_springs")
    )
    yield_ratio: FloatProperty(
        name="Elastic Limit",
        default=0.1, 
        min=0, 
        max=1,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "yield_ratio")
    )
    plasticity: FloatProperty(
        name="Plasticity",
        default=0.1, 
        min=0, 
        max=100.0,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "plasticity")
    )
    use_initial_rest_length: BoolProperty(
        name="Initial Length",
        description="Use inital length as spring rest length instead of 2 * per particle size",
        default=False,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "use_initial_rest_length")
    )
    spring_frames: IntProperty(
        name="Spring Frames",
        description="Create springs for this number of frames since particles birth (0 is always)",
        default=0,
        min=0,
        max=100,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "spring_frames")
    )
    use_factor_rest_length: BoolProperty(
        name="Factor Rest Length",
        description="Spring rest length as spring rest length instead of 2 * per particle size",
        default=True,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "use_factor_rest_length")
    )
    rest_length: FloatProperty(
        name="Rest Length",
        default=1, 
        min=0, 
        max=2,
        update=lambda self, context: particles_props_update(self, context, "global_mode_springs_sect", "rest_length")
    )


    def get_default_properties(self, target_prop):
        for prop in self.bl_rna.properties:
            if prop.identifier == target_prop:
                if hasattr(prop, "default"):
                    return prop.default